<?php
/**
 * TSI Visitor Blocker - Uninstall cleanup
 *
 * This file runs when the plugin is DELETED (not deactivated).
 * It removes options, transients, logs, and MU loader if present.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * ==========================
 * Delete plugin options
 * ==========================
 */
$options = [
    'tsi_vb_settings',
    'tsi_vb_blocked_ips',
    'tsi_vb_blocked_subnets',
    'tsi_vb_blocked_countries',
    'tsi_vb_blocked_emails',
    'tsi_vb_blocked_domains',
    'tsi_vb_abuseipdb_key',
    'tsi_vb_enable_country_block',
    'tsi_vb_enable_ip_block',
    'tsi_vb_enable_email_block',
    'tsi_vb_enable_abuseipdb',
    'tsi_vb_mu_enabled'
];

foreach ( $options as $option ) {
    delete_option( $option );
}

/**
 * ==========================
 * Delete transients
 * ==========================
 */
global $wpdb;

$wpdb->query(
    "DELETE FROM {$wpdb->options}
     WHERE option_name LIKE '_transient_tsi_vb_%'
        OR option_name LIKE '_transient_timeout_tsi_vb_%'"
);

/**
 * ==========================
 * Delete logs (if stored)
 * ==========================
 */
delete_option( 'tsi_vb_logs' );

/**
 * ==========================
 * Remove MU-plugin loader
 * ==========================
 */
$mu_loader = WP_CONTENT_DIR . '/mu-plugins/tsi-visitor-blocker-mu.php';

if ( file_exists( $mu_loader ) ) {
    @unlink( $mu_loader );
}

/**
 * ==========================
 * Optional: Multisite cleanup
 * ==========================
 */
if ( is_multisite() ) {
    $sites = get_sites();
    foreach ( $sites as $site ) {
        switch_to_blog( $site->blog_id );

        foreach ( $options as $option ) {
            delete_option( $option );
        }

        delete_option( 'tsi_vb_logs' );

        restore_current_blog();
    }
}
